<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Slip Gaji</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 11px;
            color: #000;
        }

        .container {
            border: 1px solid #000;
            padding: 12px;
        }

        .header {
            width: 100%;
        }

        .header td {
            vertical-align: top;
        }

        .company {
            font-weight: bold;
            font-size: 14px;
        }

        .alamat {
            font-size: 10px;
        }

        .judul {
            text-align: center;
            font-weight: bold;
            margin: 10px 0;
        }

        .info {
            width: 100%;
            margin-bottom: 8px;
        }

        .info td {
            padding: 2px 4px;
        }

        /* ===== TABEL GAJI ===== */
        .gaji {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        .gaji th {
            border-top: 1px solid #000;
            border-bottom: 1px solid #000;
            padding: 5px;
            text-align: center;
            background: #f2f2f2;
        }

        .gaji td {
            padding: 4px 5px;
        }

        .right {
            text-align: right;
        }

        .bold {
            font-weight: bold;
        }

        .thp {
            margin-top: 10px;
            border-top: 1px solid #000;
            padding-top: 5px;
            font-weight: bold;
        }

        .ttd {
            width: 100%;
            margin-top: 35px;
        }

        .ttd td {
            text-align: center;
        }
    </style>
</head>
<body>

<div class="container">

    {{-- HEADER --}}
    <table class="header">
        <tr>
            <td>
                <div class="company">PT. PUTRA JAYA INDOLAND</div>
                <div class="alamat">
                    Developer Perumahan Nuansa Cigelis Asri<br>
                    Pandeglang - Banten
                </div>
            </td>
            <td align="right">
                {{-- logo opsional --}}
                {{-- <img src="{{ public_path('logo.png') }}" height="40"> --}}
            </td>
        </tr>
    </table>

    <hr>

    {{-- JUDUL --}}
    <div class="judul">
        SLIP GAJI BULAN
        {{ \Carbon\Carbon::create()->month($gaji->bulan)->locale('id')->monthName }}
        {{ $gaji->tahun }}
    </div>

    {{-- INFO --}}
    <table class="info">
        <tr>
            <td width="20%">Nama</td>
            <td width="30%">: {{ $gaji->karyawan->user->nama }}</td>
            <td width="20%">Jabatan</td>
            <td width="30%">: {{ $gaji->karyawan->jabatan->nama_jabatan }}</td>
        </tr>
        <tr>
            <td>Total Hadir</td>
            <td>: {{ $gaji->total_hadir }} Hari</td>
            <td>Gaji Harian</td>
            <td>: Rp {{ number_format($gaji->gaji_harian,0,',','.') }}</td>
        </tr>
    </table>

    {{-- TABEL GAJI --}}
    <table class="gaji">
        <tr>
            <th colspan="2">PENERIMAAN</th>
            <th colspan="2">POTONGAN</th>
        </tr>

        <tr>
            <td>Gaji Pokok</td>
            <td class="right">
                Rp {{ number_format($gaji->total_hadir * $gaji->gaji_harian,0,',','.') }}
            </td>
            <td>-</td>
            <td class="right">Rp 0</td>
        </tr>

        <tr>
            <td></td><td></td>
            <td></td><td></td>
        </tr>
    </table>

    {{-- THP --}}
    <div class="thp">
        TAKE HOME PAY (THP) :
        Rp {{ number_format($gaji->total_gaji,0,',','.') }}
    </div>

    {{-- TTD --}}
    <table class="ttd">
        <tr>
            <td width="50%">
                Mengetahui,<br><br><br>
                <u>Pimpinan</u>
            </td>
            <td width="50%">
                Diterima Oleh,<br><br><br>
                <u>{{ $gaji->karyawan->user->nama }}</u>
            </td>
        </tr>
    </table>

</div>

</body>
</html>
